{
*****************************************************************************
*  Name    : RandGen2.BAS                                                    *
*  Author  : Ahmed Lazreg (Octal)                                           *
*            octal@pocketmt.com   http://www.pocketmt.com                   *
*  Notice  : Copyright (c) 2007                                             *
*          : All Rights Reserved                                            *
*  Date    : 06/10/2007                                                     *
*  Version : 1.0                                                            *
*                                                                           *
*  Notes   : A Rudimentary Pseudo Random Number Generator (Modulo based)    *
*                                                                           *
*  Usage   : Call Initialize() to initialize the Initial value of the       *
*            generator. The generator gives better values when the initial  *
*            seed value is a Prime Number.                                  *
*            For the same Initial Seed, you will get the same serie of      *
*            generated values. This let you repeat some experiences (and    *
*            this is why it's called a PSEUDO-random number generator.      *
*            If you need an automatic different initial value each time you *
*            start the number generator, you can set the initial value to   *
*            the read of an ADC value on a FLOATING Analog PIN of a PIC.    *
*            Call Rand() to get/generate a new random value                 *
*                                                                           *
*            You can try to change the Magic Values to change the           *
*            Pseudo-Random Number Generator Behaviour                       *
*                                                                           *
*****************************************************************************
}

Module RandGen2

Const MagicA = 1103515245,
      MagicB = 12345

Private Dim RndMax As LongWord // Maximum number generated by the generator

Private Dim Seed As LongWord
{
****************************************************************************
* Name    : Rand()                                                         *
* Purpose : Return a new Pseudo Random Number each time called             *
****************************************************************************
}
Public Function rand() As LongWord
   Seed = Seed * MagicA + MagicB
   result = LongWord(Seed >> 16) Mod RndMax
End Function

{
****************************************************************************
* Name    : Rand()                                                         *
* Purpose : Initialize the Random number generator                         *
*           The initial value could be a Value read from a Floating Analog *
*           PIC Pin.
****************************************************************************
}
Public Sub Initialize(ByVal InitialSeed As LongWord, ByVal pRndMax As LongWord = 255)
    RndMax = pRndMax
    Seed = InitialSeed
End Sub

{
****************************************************************************
* Name    : SetRndMax()                                                    *
* Purpose : Sets the Max Value that the Random number gen can generate     *
****************************************************************************
}
Public Sub SetRndMax(ByVal pRndMax As LongWord)
    RndMax = pRndMax
End Sub


